﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Winfoot_7_SDK;
using WinfootDefaultSystemPlugin.Controls.Strategy;

namespace WinfootDefaultSystemPlugin.Controls
{
    public partial class Link : UserControl,IControl,ICorrespondenceOS
    {
        private LinkController linkController;

        public Link()
        {
            InitializeComponent();
            CorrespondenceOSList = new List<OS>
                                       {
                                           OS.WindowsXP,
                                           OS.WindoesXP_SP1,
                                           OS.WindowsXP_SP2,
                                           OS.WindowsXP_SP3,         
                                           OS.WindowsVista,
                                           OS.WindowsVista_SP1,
#if DEBUG
                                           OS.WindowsSeven
#endif
                                       };
        }

        private void groupBox1_MouseClick(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Right)
            {
                UserHelp userHelp = new UserHelp(new Uri(@"http://www.google.co.jp/"));
                userHelp.Show();
            }
        }

        public void SetLinkState(bool b)
        {
            checkBox1.Checked = b;
        }


        public byte[] GetLinkState()
        {
            if (checkBox1.Checked)
            {
                return BitConverter.GetBytes(0x1E000000);
            }
            return BitConverter.GetBytes(0x00000000);
        }

        #region IControl メンバ

        public void Apply()
        {
            linkController.Write();
        }

        public List<WFRegistry> BackUp()
        {
            return linkController.BackUp();
        }

        #endregion

        #region ICorrespondenceOS メンバ

        public List<OS> CorrespondenceOSList { get; set; }

        #endregion

        private void Link_Load(object sender, EventArgs e)
        {
            WFUtillity wfUtillity = new WFUtillity();
            linkController = new LinkController(this,
                                                                        (ILinkStrategy)
                                                                        wfUtillity.
                                                                            GetCorrespondenceInstance
                                                                            (new List<ICorrespondenceOS>
                                                                                 {
                                                                                     new LinkDefaultStrategy()
                                                                                 }));
            linkController.Read();
        }
    }
}
